import React from "react";
import WelcomeHeader from "../components/Dashboard/WelcomeHeader";
import StatsGrid from "../components/Dashboard/StatsGrid";
import DivisionChart from "../components/Dashboard/DivisionChart";
import ProjectTypeChart from "../components/Dashboard/ProjectTypeChart";
import ProjectStatusChart from "../components/Dashboard/ProjectStatusChart";
import ProjectTrendsAnalysis from "../components/Dashboard/ProjectTrendsAnalysis";
import DeadlineAlert from "../components/Dashboard/DeadlineAlert";
import OverdueProjects from "../components/Dashboard/OverdueProjects";
import MissingFormsTable from "../components/Dashboard/MissingFormsTable";
import OutstandingPayments from "../components/Dashboard/OutstandingPayments";

// Helper function to get current user ID
const getCurrentUserId = () => {
  try {
    const user = JSON.parse(localStorage.getItem("user"));
    return user ? user.user_id : null;
  } catch (error) {
    console.error("Error getting current user:", error);
    return null;
  }
};

const DashboardHome = ({ onSectionChange }) => {
  // Get current user ID
  const currentUserId = getCurrentUserId();
  
  // Check if user has access to all data (user IDs 1, 2, 3, ...)
  const hasFullAccess = [1, 2, 3, 4, 5, 6, 8, 9].includes(currentUserId);

  return (
    <div className="space-y-3 max-w-full overflow-hidden px-2 sm:px-4 lg:px-6">
      {/* Welcome Header - Always shown */}
      <WelcomeHeader />

      {/* Conditional rendering based on user access */}
      {hasFullAccess ? (
        <>
          {/* Stats Grid */}
          <StatsGrid />

          {/* Missing Forms Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Missing Kickoff Forms */}
            <MissingFormsTable />
          </div>

          {/* Pie Charts Grid */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
            {/* Division Chart */}
            <DivisionChart onSectionChange={onSectionChange} />

            {/* Project Type Chart */}
            <ProjectTypeChart onSectionChange={onSectionChange} />
          </div>

          {/* Project Status Overview */}
          <div className="grid grid-cols-1 gap-6">
            {/* Project Status Chart */}
            <ProjectStatusChart onSectionChange={onSectionChange} />
          </div>

          {/* Enhanced Project Trends Analysis with Filters */}
          <div className="grid grid-cols-1 gap-6">
            {/* Project Trends Analysis with Division Filter */}
            <ProjectTrendsAnalysis />
          </div>

          {/* Outstanding Projects Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Outstanding Projects with Pending Payments */}
            <OutstandingPayments />
          </div>

          {/* Deadline Alert Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Projects Close to Deadline */}
            <DeadlineAlert />
          </div>

          {/* Overdue Projects Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Overdue Projects */}
            <OverdueProjects />
          </div>
        </>
      ) : (
        /* Show limited components for other users */
        <>
          {/* Missing Forms Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Missing Kickoff Forms */}
            <MissingFormsTable />
          </div>

          {/* Deadline Alert Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Projects Close to Deadline */}
            <DeadlineAlert />
          </div>

          {/* Overdue Projects Component */}
          <div className="grid grid-cols-1 gap-6">
            {/* Overdue Projects */}
            <OverdueProjects />
          </div>
        </>
      )}
    </div>
  );
};

export default DashboardHome;
