import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaChevronLeft, FaChevronRight } from 'react-icons/fa';
import ProjectCard from './ProjectCard';

const MobileProjectsView = ({ 
  currentProjects, 
  currentPage, 
  totalPages, 
  goToPrevious, 
  goToNext,
  onView
}) => {
  const { isLight } = useTheme();

  const cardBgClass = isLight 
    ? 'bg-white border border-yellow-200 shadow-md hover:shadow-lg' 
    : 'bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl';

  return (
    <div className="md:hidden space-y-4">
      {currentProjects.map((project) => (
        <ProjectCard 
          key={project.project_id} 
          project={project} 
          onView={onView}
        />
      ))}

      {/* Mobile Pagination */}
      {totalPages > 1 && (
        <div className={`${cardBgClass} rounded-xl px-4 sm:px-6 py-3 sm:py-4`}>
          <div className="flex flex-col sm:flex-row justify-between items-center gap-3">
            {/* Page Info */}
            <div className={`text-sm text-center ${
              isLight ? 'text-gray-600' : 'text-gray-300'
            }`}>
              Page {currentPage} of {totalPages} ({currentProjects.length} projects)
            </div>

            {/* Pagination Controls */}
            <div className="flex items-center justify-center gap-2">
              {/* Previous Button */}
              <button
                onClick={goToPrevious}
                disabled={currentPage === 1}
                className={`flex items-center justify-center gap-1 px-3 py-2 rounded-lg text-sm ${
                  currentPage === 1
                    ? (isLight ? 'bg-gray-100 text-gray-400 cursor-not-allowed' : 'bg-gray-600 text-gray-500 cursor-not-allowed')
                    : (isLight ? 'bg-white hover:bg-gray-100 text-gray-700 shadow-sm' : 'bg-gray-600 hover:bg-gray-500 text-gray-200')
                }`}
              >
                <FaChevronLeft className="text-xs flex-shrink-0" />
                <span>Prev</span>
              </button>

              {/* Current Page */}
              <div className={`px-3 py-2 rounded-lg font-medium text-sm ${
                isLight ? 'bg-amber-500 text-white' : 'bg-gray-300 text-gray-900'
              }`}>
                {currentPage}
              </div>

              {/* Next Button */}
              <button
                onClick={goToNext}
                disabled={currentPage === totalPages}
                className={`flex items-center justify-center gap-1 px-3 py-2 rounded-lg text-sm ${
                  currentPage === totalPages
                    ? (isLight ? 'bg-gray-100 text-gray-400 cursor-not-allowed' : 'bg-gray-600 text-gray-500 cursor-not-allowed')
                    : (isLight ? 'bg-white hover:bg-gray-100 text-gray-700 shadow-sm' : 'bg-gray-600 hover:bg-gray-500 text-gray-200')
                }`}
              >
                <span>Next</span>
                <FaChevronRight className="text-xs flex-shrink-0" />
              </button>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

export default MobileProjectsView; 