import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaTimes } from 'react-icons/fa';

const FilterStatusBar = ({ 
  filteredEmployees, 
  totalEmployees, 
  selectedDivision, 
  selectedRole, 
  selectedProject, 
  setSelectedDivision, 
  setSelectedRole, 
  setSelectedProject 
}) => {
  const { isLight } = useTheme();

  const cardBgClass = isLight 
    ? 'bg-white border border-yellow-200 shadow-md hover:shadow-lg' 
    : 'bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl';
  
  const textClass = isLight 
    ? 'text-amber-700' 
    : 'text-gray-300';

  const hasActiveFilters = selectedDivision !== 'All' || selectedRole !== 'All' || selectedProject !== 'All';
  const isFiltered = filteredEmployees.length !== totalEmployees || hasActiveFilters;

  if (!isFiltered) return null;

  return (
    <div className={`${cardBgClass} rounded-xl px-4 sm:px-6 py-3 transition-all duration-300 border-l-4 ${
      isLight ? 'border-l-blue-500' : 'border-l-blue-400'
    }`}>
      <div className="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
        {/* Filter Results Info */}
        <div className="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4">
          {/* Results Count */}
          <div className="flex items-center gap-2">
            <div className={`w-2 h-2 rounded-full ${isLight ? 'bg-blue-500' : 'bg-blue-400'}`}></div>
            <span className={`text-sm font-medium ${textClass}`}>
              Showing {filteredEmployees.length} of {totalEmployees} employees
            </span>
          </div>
          
          {/* Active Filters */}
          {hasActiveFilters && (
            <div className="flex flex-wrap items-center gap-2">
              <span className={`text-xs ${isLight ? 'text-gray-600' : 'text-gray-400'}`}>Filters:</span>
              {selectedDivision !== 'All' && (
                <span className={`px-2 py-1 rounded-full text-xs font-medium ${
                  isLight ? 'bg-blue-100 text-blue-800' : 'bg-blue-900/30 text-blue-300'
                }`}>
                  Division: {selectedDivision}
                </span>
              )}
              {selectedRole !== 'All' && (
                <span className={`px-2 py-1 rounded-full text-xs font-medium ${
                  isLight ? 'bg-green-100 text-green-800' : 'bg-green-900/30 text-green-300'
                }`}>
                  Role: {selectedRole}
                </span>
              )}
              {selectedProject !== 'All' && (
                <span className={`px-2 py-1 rounded-full text-xs font-medium ${
                  isLight ? 'bg-purple-100 text-purple-800' : 'bg-purple-900/30 text-purple-300'
                }`}>
                  Project: {selectedProject}
                </span>
              )}
            </div>
          )}
        </div>

        {/* Clear Filters Button */}
        {hasActiveFilters && (
          <div className="flex items-center gap-2">
            <button
              onClick={() => {
                setSelectedDivision('All');
                setSelectedRole('All');
                setSelectedProject('All');
              }}
              className={`flex items-center gap-2 px-3 py-2 rounded-lg text-sm font-medium transition-all duration-200 hover:scale-105 ${
                isLight
                  ? 'bg-red-100 hover:bg-red-200 text-red-700 border border-red-200'
                  : 'bg-red-900/20 hover:bg-red-900/30 text-red-400 border border-red-800'
              }`}
              title="Clear all active filters"
            >
              <FaTimes className="text-xs" />
              <span>Clear All Filters</span>
              <span className={`text-xs px-1.5 py-0.5 rounded-full ${
                isLight ? 'bg-red-200 text-red-800' : 'bg-red-800/50 text-red-300'
              }`}>
                {[selectedDivision !== 'All', selectedRole !== 'All', selectedProject !== 'All'].filter(Boolean).length}
              </span>
            </button>
          </div>
        )}
      </div>
    </div>
  );
};

export default FilterStatusBar; 