import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';
import { FaSearch } from 'react-icons/fa';

const SearchFilter = ({ searchTerm, setSearchTerm, filterActivity, setFilterActivity }) => {
  const { isLight } = useTheme();

  const cardBgClass = isLight 
    ? 'bg-white border border-yellow-200 shadow-md hover:shadow-lg' 
    : 'bg-gradient-to-br from-gray-800 to-slate-800 border border-gray-700 shadow-lg hover:shadow-xl';

  const activityTypes = ["All", "Login/Logout", "Tasks", "Meetings", "Updates"];

  return (
    <div className={`${cardBgClass} rounded-xl p-6 transition-all duration-300`}>
      <div className="flex flex-col lg:flex-row gap-4">
        <div className="flex-1">
          <div className="relative">
            <FaSearch className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 flex-shrink-0" />
            <input
              type="text"
              placeholder="Search by employee name or action..."
              value={searchTerm}
              onChange={(e) => setSearchTerm(e.target.value)}
              className={`w-full pl-10 pr-4 py-2 rounded-lg border transition-all duration-200 ${
                isLight 
                  ? 'border-gray-300 bg-white text-gray-900 focus:ring-yellow-500 focus:border-yellow-500' 
                  : 'border-gray-600 bg-gray-700 text-gray-100 focus:ring-gray-400 focus:border-gray-400 placeholder-gray-400'
              }`}
            />
          </div>
        </div>
        <select
          value={filterActivity}
          onChange={(e) => setFilterActivity(e.target.value)}
          className={`px-3 py-2 rounded-lg border transition-all duration-200 ${
            isLight 
              ? 'border-gray-300 bg-white text-gray-900 focus:ring-yellow-500 focus:border-yellow-500' 
              : 'border-gray-600 bg-gray-700 text-gray-100 focus:ring-gray-400 focus:border-gray-400'
          }`}
        >
          {activityTypes.map(type => (
            <option key={type} value={type}>{type}</option>
          ))}
        </select>
      </div>
    </div>
  );
};

export default SearchFilter; 