import React from "react";
import { useTheme } from "../../contexts/ThemeContext";

const StatsCard = ({ stat }) => {
  const { isLight } = useTheme();

  const cardBgClass = isLight
    ? "bg-white border border-yellow-200 shadow-md hover:shadow-lg active:shadow-sm"
    : "bg-slate-800 border border-slate-700 shadow-xl hover:shadow-2xl hover:border-slate-600 active:shadow-lg";

  const headingClass = isLight ? "text-amber-800" : "text-slate-100";
  const textClass = isLight ? "text-amber-700" : "text-slate-300";
  const descriptionClass = isLight ? "text-amber-600" : "text-slate-400";

  const getStatColor = (color) => {
    const colors = {
      blue: isLight ? "text-blue-600" : "text-cyan-400",
      green: isLight ? "text-green-600" : "text-emerald-400",
      purple: isLight ? "text-purple-600" : "text-purple-400",
      orange: isLight ? "text-orange-600" : "text-orange-400",
    };
    return colors[color] || colors.blue; // fallback to blue if color not found
  };

  return (
    <div
      className={`${cardBgClass} rounded-xl p-3 sm:p-4 lg:p-6 transition-all duration-300 hover:scale-105 active:scale-95 cursor-pointer touch-manipulation select-none`}
      style={{ minHeight: "120px" }}
    >
      {/* Icon - Top Right */}
      <div className="flex items-center justify-end mb-2 sm:mb-3 lg:mb-4">
        <div
          className={`${getStatColor(
            stat.color
          )} text-xl sm:text-2xl lg:text-3xl`}
        >
          {stat.icon}
        </div>
      </div>

      {/* Value - Large and Prominent */}
      <div
        className={`text-2xl sm:text-3xl lg:text-4xl font-bold ${headingClass} mb-1 leading-tight`}
      >
        {stat.value}
      </div>

      {/* Title - Responsive Text */}
      <div
        className={`${textClass} text-xs sm:text-sm font-medium mb-1 leading-tight`}
      >
        {stat.title}
      </div>

      {/* Description - Smaller Text */}
      {stat.description && (
        <div
          className={`${descriptionClass} text-xs leading-tight hidden sm:block`}
        >
          {stat.description}
        </div>
      )}
    </div>
  );
};

export default StatsCard;
