// API Configuration
export const API_BASE_URL = "http://eframeehs.in:8000";
// export const API_BASE_URL = "http://localhost:3000";
export const API_BASE_URL_WITH_API = `${API_BASE_URL}/api`;

// Helper function to build full API URLs
export const buildApiUrl = (endpoint) => {
  // Remove leading slash if present to avoid double slashes
  const cleanEndpoint = endpoint.startsWith("/") ? endpoint.slice(1) : endpoint;
  return `${API_BASE_URL}/${cleanEndpoint}`;
};

// Common API endpoints
export const API_ENDPOINTS = {
  // Authentication
  LOGIN: "api/user_login/login",
  CHANGE_PASSWORD: "api/users/change-password",

  // Employees
  EMPLOYEES: "api/employees",
  EMPLOYEES_FILTER: "api/employees/filter",
  EMPLOYEES_DETAILS: "api/employees",
  EMPLOYEE_BY_ID: (id) => `api/employees/${id}`,
  EMPLOYEE_PROJECTS: "api/employees_projects",
  EMPLOYEE_PROJECT_BY_ID: (empId, projectId) =>
    `api/employees_projects/${empId}/${projectId}`,

  // Projects
  PROJECTS: "api/projects",
  PROJECT_BY_ID: (id) => `api/projects/${id}`,
  PROJECT_GENERATE_ID: "api/projects/generate-id",
  PROJECT_TYPE: "api/project_type",
  PROJECT_STATUS: "api/project_status",
  PROJECT_PRIORITY: "api/project_priority_level",
  PROJECT_MISSING_FORMS: "api/projects/missing-forms",
  PROJECT_FORM_UPLOAD: "api/kickoff_form/upload-project-form",
  PROJECT_FORM_DOWNLOAD: (id) => `api/kickoff_form/download/${id}`,

  // Divisions/Departments
  DIVISIONS: "api/divisions",
  DIVISION_COUNT: "api/divisions/count",

  // Roles
  ROLES: "api/roles",

  // Invoice
  INVOICE_STATUS: "api/invoice_status",

  // PO Status
  PO_STATUS: "api/po_status",

  // Forms
  KICKOFF_FORM: "api/kickoff_form",
  KICKOFF_FORM_UPLOAD: "api/kickoff_form/upload",
  KICKOFF_FORM_DOWNLOAD: (id) => `api/kickoff_form/download/${id}`,
  KICKOFF_FORM_BY_ID: (id) => `api/kickoff_form/form/${id}`,

  // Filterations
  PROJECTS_WITH_IDS: "api/filterations/projects_with_ids",
  PROJECTS_FROM_VIEW: "api/filterations/projects_from_view",
  PROJECTS_WITH_LEAD_DETAILS: "api/filterations/projects_with_lead_details",
  EMPLOYEES_BY_PROJECT: (projectId) =>
    `api/filterations/employees_by_project?project_id=${projectId}`,
  PROJECTS_BY_DIVISION: (division) =>
    `api/filterations/projects_by_division?division=${encodeURIComponent(
      division
    )}`,
  PROJECTS_BY_DIVISION_ACCURATE: (division_id) =>
    `api/filterations/projects_by_division_accurate?division_id=${division_id}`,
  EMPLOYEES_BY_DIVISION: (division) =>
    `api/filterations/employees_by_division?division=${encodeURIComponent(
      division
    )}`,
  EMPLOYEES_BY_DIVISION_ACCURATE: (division_id) =>
    `api/filterations/employees_by_division_accurate?division_id=${division_id}`,
  DIVISION_EMPLOYEE_COUNT: "api/filterations/division_employee_count",
  DIVISION_EMPLOYEE_COUNT_BY_NAME_ACCURATE:
    "api/filterations/division_employee_count_by_name_accurate",
  DIVISION_DETAILED_COUNTS: "api/filterations/division_detailed_counts",
  ALL_PROJECT_LOGS: "api/filterations/all_project_logs",
  PROJECT_LOGS_BY_DATE: "api/filterations/project_logs_by_date_range",
  ALL_EMPLOYEE_LOGS: "api/filterations/all_employee_logs",
  EMPLOYEE_LOGS_BY_DATE: "api/filterations/employee_logs_by_date_range",
  PROJECT_TYPE_COUNT: "api/filterations/project_type_count",
  PROJECT_STATUS_COUNT: "api/filterations/project_status_count",
  COMPLETED_TASKS_COUNT: "api/filterations/completed_tasks_count",
  ACTIVE_PROJECTS_COUNT: "api/filterations/active_projects_count",
  OUTSTANDING_PROJECTS: "api/filterations/outstanding_projects",

  // Dashboard
  EMPLOYEE_COUNT: "api/employees/count",
  PROJECT_COUNT: "api/projects/count",
  SYSTEM_HEALTH_STATUS: "api/system-health/status",

  // Employee Log
  EMPLOYEE_LOG: "api/employee_log/",

  // Employee Contributions
  EMPLOYEE_CONTRIBUTIONS: "api/employee_contributions",
  ADD_EMPLOYEE_CONTRIBUTION:
    "api/employee_contributions/addEmployeeContribution",
  UPDATE_EMPLOYEE_CONTRIBUTION:
    "api/employee_contributions/updateEmployeeContribution",
  GET_EMPLOYEE_CONTRIBUTION:
    "api/employee_contributions/getEmployeeContribution",
};
