import React from 'react';
import { FaCheckCircle, FaInfoCircle, FaExclamationCircle, FaCodeBranch } from 'react-icons/fa';
import SummaryCard from './SummaryCard';

const SummaryCards = () => {
  const summaryData = [
    {
      title: "Total Projects",
      value: "15",
      icon: FaCodeBranch,
      iconColor: "text-blue-500"
    },
    {
      title: "Active Projects",
      value: "8",
      icon: FaInfoCircle,
      iconColor: "text-green-500"
    },
    {
      title: "Completed Projects",
      value: "7",
      icon: FaCheckCircle,
      iconColor: "text-purple-500"
    },
    {
      title: "Project Updates",
      value: "23",
      icon: FaExclamationCircle,
      iconColor: "text-orange-500"
    }
  ];

  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
      {summaryData.map((item, index) => (
        <SummaryCard
          key={index}
          title={item.title}
          value={item.value}
          icon={item.icon}
          iconColor={item.iconColor}
        />
      ))}
    </div>
  );
};

export default SummaryCards; 