import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';

const SummaryCard = ({ title, value, icon, iconColor }) => {
  const { isLight } = useTheme();

  const cardBgClass = isLight 
    ? 'bg-white border border-yellow-200 shadow-md hover:shadow-lg' 
    : 'bg-slate-800 border border-slate-700 shadow-xl hover:shadow-2xl';
  
  const headingClass = isLight 
    ? 'text-amber-800' 
    : 'text-slate-100';
  
  const textClass = isLight 
    ? 'text-amber-700' 
    : 'text-slate-300';

  return (
    <div className={`${cardBgClass} rounded-xl p-6 transition-all duration-300 hover:scale-105`}>
      <div className="flex items-center justify-between">
        <div>
          <p className={`${textClass} text-sm`}>{title}</p>
          <p className={`text-2xl font-bold ${headingClass}`}>{value}</p>
        </div>
        <div className={`text-${iconColor} text-3xl`}>
          {icon}
        </div>
      </div>
    </div>
  );
};

export default SummaryCard; 