const express = require("express");
const app = express();
const dotenv = require("dotenv");
const user_route = require("./routes/users");
const auth_route = require("./routes/auth");

const divisions_route = require("./routes/divisions");
const roles_route = require("./routes/roles");
const divisions_roles_route = require("./routes/divisions_roles");
const employees_route = require("./routes/employees");
const employees_projects_route = require("./routes/employees_projects");
const project_type_route = require("./routes/project_type");
const project_status_route = require("./routes/project_status");
const projects_route = require("./routes/projects");
const invoice_status_route = require("./routes/invoice_status");
const project_priority_level_route = require("./routes/project_priority_level");
const po_status_route = require("./routes/po_status");
const employee_log_route = require("./routes/employee_log");
const project_log_route = require("./routes/project_log");
const filterations_route = require("./routes/filterations");
const employees_list_route = require("./routes/employees_list");
const login_route = require("./routes/login");
const kickoff_form_route = require("./routes/kickoff_form");
const system_health_route = require("./routes/system_health");
const employee_contributions_route = require("./routes/employee_contribution");

dotenv.config();
const cors = require("cors");

const mysql = require("mysql2"); // Add mysql2 import
app.use(cors());

// MySQL connection setup
const db = mysql.createConnection({
  host: process.env.MYSQL_HOST,
  user: process.env.MYSQL_USER,
  password: process.env.MYSQL_PASSWORD,
  database: process.env.MYSQL_DATABASE,
});

db.connect((err) => {
  if (err) {
    // Database connection error
  }
});

app.use(express.json());

app.use("/api/auth", auth_route);
app.use("/api/users", user_route);

app.use("/api/divisions", divisions_route);
app.use("/api/roles", roles_route);
app.use("/api/divisions_roles", divisions_roles_route);
app.use("/api/employees", employees_route);
app.use("/api/employees_projects", employees_projects_route);
app.use("/api/project_type", project_type_route);
app.use("/api/project_status", project_status_route);
app.use("/api/projects", projects_route);
app.use("/api/invoice_status", invoice_status_route);
app.use("/api/project_priority_level", project_priority_level_route);
app.use("/api/po_status", po_status_route);
app.use("/api/employee_log", employee_log_route);
app.use("/api/project_log", project_log_route);
app.use("/api/filterations", filterations_route);
app.use("/api/user_login", login_route);
app.use("/api/employees_details", employees_list_route);
app.use("/api/kickoff_form", kickoff_form_route);
app.use("/api/system-health", system_health_route);
app.use("/api/employee_contributions", employee_contributions_route);
const PORT = process.env.PORT;

app.listen(PORT, () => {
  // Server started
});
